/*
 * Decompiled with CFR 0.152.
 */
package com.gjhi.tinkersinnovation.library.stats;

import com.gjhi.tinkersinnovation.TinkersInnovation;
import com.gjhi.tinkersinnovation.library.stats.ShieldMaterialStats;
import com.gjhi.tinkersinnovation.register.TinkersInnovationToolStats;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.FloatLoadable;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.materials.stats.IRepairableMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatType;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public record BombShellStats(int durability, int piece_count, float piece_damage, float melee_range_damage) implements IRepairableMaterialStats
{
    public static final MaterialStatsId ID = new MaterialStatsId(TinkersInnovation.getResource("bomb_shell"));
    public static final MaterialStatType<ShieldMaterialStats> TYPE = new MaterialStatType(ID, (IMaterialStats)new BombShellStats(1, 1, 1.0f, 1.0f), RecordLoadable.create((RecordField)IRepairableMaterialStats.DURABILITY_FIELD, (RecordField)IntLoadable.FROM_ZERO.defaultField("piece_count", (Object)1, true, BombShellStats::piece_count), (RecordField)FloatLoadable.FROM_ZERO.defaultField("piece_damage", (Object)Float.valueOf(1.0f), true, BombShellStats::piece_damage), (RecordField)FloatLoadable.FROM_ZERO.defaultField("melee_range_damage", (Object)Float.valueOf(1.0f), true, BombShellStats::melee_range_damage), BombShellStats::new));
    private static final List<Component> DESCRIPTION = ImmutableList.of((Object)ToolStats.DURABILITY.getDescription(), (Object)TinkersInnovationToolStats.PIECE_COUNT.getDescription(), (Object)TinkersInnovationToolStats.PIECE_DAMAGE.getDescription(), (Object)ToolStats.ATTACK_DAMAGE.getDescription(), (Object)ToolStats.PROJECTILE_DAMAGE.getDescription());

    public MaterialStatType<?> getType() {
        return TYPE;
    }

    public List<Component> getLocalizedInfo() {
        ArrayList info = Lists.newArrayList();
        info.add(ToolStats.DURABILITY.formatValue((float)this.durability));
        info.add(TinkersInnovationToolStats.PIECE_COUNT.formatValue((float)this.piece_count));
        info.add(TinkersInnovationToolStats.PIECE_DAMAGE.formatValue(this.piece_damage));
        info.add(ToolStats.ATTACK_DAMAGE.formatValue(this.melee_range_damage));
        info.add(ToolStats.PROJECTILE_DAMAGE.formatValue(this.melee_range_damage));
        return info;
    }

    @NotNull
    public List<Component> getLocalizedDescriptions() {
        return DESCRIPTION;
    }

    public void apply(ModifierStatsBuilder builder, float scale) {
        ToolStats.DURABILITY.update(builder, Float.valueOf((float)this.durability * scale));
        TinkersInnovationToolStats.PIECE_COUNT.update(builder, Float.valueOf((float)this.piece_count * scale));
        TinkersInnovationToolStats.PIECE_DAMAGE.update(builder, Float.valueOf(this.piece_damage * scale));
        ToolStats.ATTACK_DAMAGE.update(builder, Float.valueOf(this.melee_range_damage * scale));
        ToolStats.PROJECTILE_DAMAGE.update(builder, Float.valueOf(this.melee_range_damage * scale));
    }
}

